// src/server.js
import app from './app.js';
import mongoose from 'mongoose';
import cors from 'cors';
import http from 'http';

const server = http.createServer(app);





mongoose.connect(process.env.MONGO_URI, { useNewUrlParser:true, useUnifiedTopology:true })
  .then(() => {
    console.log('MongoDB connected successfully');
   
  })
  .catch(err => console.error('DB Connection error:', err));

const PORT = process.env.PORT || 1000;

server.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});