import express from 'express';
import { signup, login, getSignupUser, verifyToken } from '../controllers/authController.js';
import { authenticateToken, authorizeRoles } from '../middleware/authMiddleware.js';

const authRoute = express.Router();

authRoute.post('/signup', signup);
authRoute.post('/login', login);
authRoute.get('/getalluser',authenticateToken,authorizeRoles('admin'), getSignupUser);
authRoute.get('/verify',verifyToken)

export default authRoute;
