import express from 'express';
import { getUsers, addUser, updateUser, deleteUser, getDashboardUsers, renewUser } from '../controllers/userController.js';
import { authenticateToken, authorizeRoles } from '../middleware/authMiddleware.js';

const routerUser = express.Router();

routerUser.get('/',authenticateToken, getUsers);
routerUser.post('/',authenticateToken, addUser);
routerUser.put('/:id',authenticateToken, updateUser);
routerUser.delete('/:id',authenticateToken,authorizeRoles('admin'), deleteUser);
routerUser.get('/dash',authenticateToken, getDashboardUsers);
routerUser.post('/renew/:id',authenticateToken, renewUser);





export default routerUser;