export function calcRenewalDate(startPlanData, plan) {
  const d = new Date(startPlanData);
  switch (plan) {
    case 'monthly':
      d.setMonth(d.getMonth() + 1);
      break;
    case 'quarterly':
      d.setMonth(d.getMonth() + 3);
      break;
    case 'annually':
      d.setFullYear(d.getFullYear() + 1);
      break;
    default:
      throw new Error(`Unknown plan type: ${plan}`);
  }
  return d;
}